IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'CF_Contrato_Cupo_Inc_Suma_Total') 
                   and type = 'FN')
BEGIN
    DROP FUNCTION CF_Contrato_Cupo_Inc_Suma_Total
END
GO

CREATE FUNCTION CF_Contrato_Cupo_Inc_Suma_Total 
(		@pId_Familia				INT
		,@pId_Prod_Familia_Sala		INT
		,@pId_Prod_Familia_Horario	INT
		,@pId_Producto				CHAR(14)
		,@pFecha_Desde				DATETIME
		,@pFecha_Hasta				DATETIME
		,@pId_Contrato				INT 
)		
RETURNS INT
AS
BEGIN

/* Esta funcion devuelve 1 si el cntrato especificado esta incluido en la suma total del cupo*/
/* Si se modifica esta funcion se debe modificar  CF_Contratos_Cupos_Contar_Rangos  */


	DECLARE @Flag_Valida_Cupo	TINYINT
			,@Cant INT

	SELECT @Flag_Valida_Cupo = Flag_Valida_Cupo FROM Prod_Familias WHERE Id_Familia = @pId_Familia

	IF (@pFecha_Desde < GETDATE())
	BEGIN
		SET @pFecha_Desde = GETDATE()
	END

	SET @pId_Contrato = ISNULL(@pId_Contrato,0)


	IF @Flag_Valida_Cupo = 0 OR @pId_Contrato = 0
	BEGIN
	   RETURN 0
	END


	IF @Flag_Valida_Cupo = 1  --Por Sala
	BEGIN
       SELECT @Cant = COUNT(*) FROM Contratos C, Contratos_Prod P
                               WHERE C.Id_Contrato = P.Id_Contrato 
                               AND C.Activo = 1 
							   AND C.Fecha_Desde <= @pFecha_Hasta + 1
							   AND ISNULL(C.Fecha_Hasta, DATEADD(DAY, 1, C.Fecha_Desde)) >= @pFecha_Desde
							   AND C.Id_Contrato = @pId_Contrato
							   AND P.Id_Prod_Familia_Sala = @pId_Prod_Familia_Sala
	   RETURN 1
	END

	IF @Flag_Valida_Cupo = 2  --Por Sala Y Horario
	BEGIN
       SELECT @Cant = COUNT(*) FROM Contratos C, Contratos_Prod P, Contratos_Prod_Horarios H
                               WHERE C.Id_Contrato = P.Id_Contrato 
                               AND C.Activo = 1 
							   AND C.Fecha_Desde <=  @pFecha_Hasta + 1
							   AND ISNULL(C.Fecha_Hasta,C.Fecha_Desde + 1) >= @pFecha_Desde
							   AND P.Id_Prod_Familia_Sala = @pId_Prod_Familia_Sala
							   AND H.Id_Contrato = C.Id_Contrato
							   AND C.Id_Contrato = @pId_Contrato
							   AND H.Id_Prod_Familia_Horario = @pId_Prod_Familia_Horario
	   RETURN 1
	END

	IF @Flag_Valida_Cupo = 3  --Por Sala Y Producto
	BEGIN
       SELECT @Cant = COUNT(*) FROM Contratos C, Contratos_Prod P
                               WHERE C.Id_Contrato = P.Id_Contrato 
                               AND C.Activo = 1 
							   AND C.Fecha_Desde <=  @pFecha_Hasta + 1
							   AND ISNULL(C.Fecha_Hasta,C.Fecha_Desde + 1) >= @pFecha_Desde
							   AND P.Id_Prod_Familia_Sala = @pId_Prod_Familia_Sala
							   AND P.Id_Producto = @pId_Producto
							   AND C.Id_Contrato = @pId_Contrato
	   RETURN 1
	END

	IF @Flag_Valida_Cupo = 4  --Por Sala , Producto y Horario
	BEGIN
       SELECT @Cant = COUNT(*) FROM Contratos C, Contratos_Prod P, Contratos_Prod_Horarios H
                               WHERE C.Id_Contrato = P.Id_Contrato 
                               AND C.Activo = 1 
							   AND C.Fecha_Desde <=  @pFecha_Hasta + 1
							   AND ISNULL(C.Fecha_Hasta,C.Fecha_Desde + 1) >= @pFecha_Desde
							   AND P.Id_Prod_Familia_Sala = @pId_Prod_Familia_Sala
							   AND H.Id_Contrato = C.Id_Contrato
							   AND H.Id_Prod_Familia_Horario = @pId_Prod_Familia_Horario
							   AND P.Id_Producto = @pId_Producto
							   AND C.Id_Contrato = @pId_Contrato
	   RETURN 1
	END

	IF @Flag_Valida_Cupo = 5  --Por Producto y Horario
	BEGIN
       SELECT @Cant = COUNT(*) FROM Contratos C, Contratos_Prod P, Contratos_Prod_Horarios H
                               WHERE C.Id_Contrato = P.Id_Contrato 
                               AND C.Activo = 1 
							   AND C.Fecha_Desde <=  @pFecha_Hasta + 1
							   AND ISNULL(C.Fecha_Hasta,C.Fecha_Desde + 1) >= @pFecha_Desde
							   AND H.Id_Contrato = C.Id_Contrato
							   AND H.Id_Prod_Familia_Horario = @pId_Prod_Familia_Horario
							   AND P.Id_Producto = @pId_Producto
							   AND C.Id_Contrato = @pId_Contrato
	   RETURN 1
	END

	IF @Flag_Valida_Cupo = 6  --Por Horario
	BEGIN
       SELECT @Cant = COUNT(*) FROM Contratos C, Contratos_Prod P, Contratos_Prod_Horarios H
                               WHERE C.Id_Contrato = P.Id_Contrato 
                               AND C.Activo = 1 
							   AND C.Fecha_Desde <=  @pFecha_Hasta + 1
							   AND ISNULL(C.Fecha_Hasta, DATEADD(DAY, 1, C.Fecha_Desde)) >= @pFecha_Desde
							   AND H.Id_Contrato = C.Id_Contrato
							   AND H.Id_Prod_Familia_Horario = @pId_Prod_Familia_Horario
							   --AND P.Id_Producto = @pId_Producto				//02/03/2021
							   AND C.Id_Contrato = @pId_Contrato
	   RETURN 1
	END
	
	IF @Flag_Valida_Cupo = 7  --Por Familia
	BEGIN
       SELECT @Cant = COUNT(*) FROM Contratos C, Contratos_Prod P, Productos PR
                               WHERE C.Id_Contrato = P.Id_Contrato
							   AND P.Id_Producto = PR.Id_Producto
							   AND C.Activo = 1 
							   AND C.Fecha_Desde <=  @pFecha_Hasta + 1
							   AND ISNULL(C.Fecha_Hasta, DATEADD(DAY, 1, C.Fecha_Desde)) >= @pFecha_Desde
							   AND PR.Id_Familia = @pId_Familia
							   AND C.Id_Contrato = @pId_Contrato

	   RETURN 1
	END

	RETURN 0
END	
		
   
